/*
 * @(#)DataURITransferHandler.java  1.0  2012-03-05
 * 
 * Copyright (c) 2012 Werner Randelshofer, Immensee, Switzerland.
 * All rights reserved.
 * 
 * You may not use, copy or modify this file, except in compliance with the
 * license agreement you entered into with Werner Randelshofer.
 * For details see accompanying license terms.
 */
package ch.randelshofer.datauri;

import ch.randelshofer.gui.datatransfer.FileTextFieldTransferHandler;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.io.Base64;

/**
 * {@code DataURITransferHandler}.
 *
 * @author Werner Randelshofer
 * @version 1.0 2012-03-05 Created.
 */
public class DataURITransferHandler extends FileTextFieldTransferHandler {
    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        JTextComponent c = (JTextComponent) comp;
        if (!(/*c.isEditable() &&*/ c.isEnabled())) {
            return false;
        }

        for (DataFlavor flavor : transferFlavors) {
            if (flavor.isFlavorJavaFileListType()
                    || flavor.isFlavorTextType()) {
                return true;
            }
        }

        return false;
    }

    @Override
    protected boolean importFiles(final JTextComponent c, List<File> files) {
        final File file = files.get(0);
        c.setText("Processing...");
        new Worker<String>() {

            @Override
            protected String construct() throws Exception {
                String ext = file.getName().toString();
                {
                    int p = ext.lastIndexOf('.');
                    if (p != -1) {
                        ext = ext.substring(p + 1);
                    }
                }
                ext = ext.toLowerCase();

                StringBuilder b = new StringBuilder("<img src=\"data:image/");
                b.append(ext).append(";base64,\n");
                b.append(Base64.encodeFromFile(file.getPath()));
                b.append("\">");

                return b.toString();
            }

            @Override
            protected void done(String value) {
                c.setText(value);
            }
            
            
        }.start();
        return super.importFiles(c, files);
    }
}
